# LogicSR

LogicSR is a benchmark framework for logic symbolic regression, supporting comparison and evaluation of various algorithms and methods.

## Features

- **Multiple Algorithm Support**: Including symbolic regression, neural networks, logic synthesis methods and LLM
- **Batch Testing**: Support for testing datasets of different scales
- **Result Analysis**: Automatic generation of accuracy and performance reports

## Requirements

- Python 3.8
- CUDA support (optional, for GPU acceleration)
- Related dependencies (see requirements.txt)

## Quick Start

### 1. Create Environment
```bash
# Recommended: Create conda environment
conda create -n logicsr python=3.8
conda activate logicsr

# Alternative: Create virtual environment
python -m venv logicsr
source logicsr/bin/activate  # On Linux/Mac
# logicsr\Scripts\activate  # On Windows
```

## Note

Due to anonymous submission constraints, we have removed all links that appeared in the code for this version of the submission.


### 2. Install Dependencies

```bash
pip install -r requirements.txt
```

### 3. Configure API Keys (if needed)
```bash
# GPT-4O Configuration
export GPT4O_API_KEY="your-gpt-4o-api-key"
export GPT4O_API_BASE=" "
export GPT4O_API_VERSION="2024-08-01-preview"
export GPT4O_MODEL="gpt-4o"

# GPT-O3 Configuration
export GPT_O3_API_KEY="your-gpt-o3-api-key"
export GPT_O3_API_BASE=" "
export GPT_O3_API_VERSION="2025-01-01-preview"
```

#### LLM Parameters 

- Defaults (our current runs):
  - Decoding params not set in code → use server defaults
  - Attempts per task: 1 

- How to tune (set env vars before running):
```bash
# If unset → server defaults will be used
export LLM_TEMPERATURE=0.2     # 0.2=robust, 0.7=more exploratory
export LLM_TOP_P=0.9
export LLM_MAX_TOKENS=10000
export LLM_SEED=123
# o3 only (if your endpoint supports it)
export LLM_REASONING_EFFORT=medium   # or: high
```

### 4. Download External Models (if needed)

**Option A: One-click installation**
```bash
chmod +x install_external.sh
./install_external.sh
```

**Option B: Manual installation**

#### ABC Compilation 
```bash
cd external/
git clone " "
cd abc/
make ABC_USE_NO_READLINE=1 
#If you don't have readline development libraries, use `make ABC_USE_NO_READLINE=1` to disable readline support.
```

#### BoolFormer Models 
```bash
cd external/boolformer/
# Download noiseless model (263MB)
wget " " -O boolformer_noiseless.pt
# Download noisy model (518MB)  
wget " " -O boolformer_noisy.pt
```

#### NeuraLUT Dependencies 
```bash
# Install required conda packages
conda install -y packaging pyparsing
conda install -y docrep -c conda-forge
# Install specific version of brevitas from GitHub
pip install --no-cache-dir git+" "
# Install other dependencies
pip install pyverilator==0.7.0
```

#### DiffLogic Dependencies
```bash
# Install DiffLogic from source (requires compilation)
cd external/difflogic/
python setup.py install
```

#### PySR Dependencies 
```bash
# Install Julia environment
conda install -c conda-forge julia
# Install PyCall 
julia -e 'using Pkg; Pkg.add("PyCall")'
# Install SymbolicRegression.jl
julia -e 'using Pkg; Pkg.add("SymbolicRegression")'
```

### 5. Run Tests

```bash
# Basic usage
python test.py -m [method_name] -d [data_path] -p [operator]

# Test single method
python test.py -m sr_gplearn -d ANO/in5_out5/and10/noise_0/1.truth -p and not or

# Test multiple methods
python test.py -m sr_gplearn nn_difflogic -d ANO/in5_out5/and10/noise_0/1.truth -p and not or

# Limit number of files
python test.py -m sr_gplearn -d ANO/in5_out5/and10/noise_0 -p and not or -n 10 

# Custom train/test split ratio
python test.py -m sr_gplearn -d ANO/in5_out5/and10/noise_0 -p and not or -s 0.8
```

## Supported Methods

**Symbolic Regression:** sr_pysr (PySR), sr_gplearn (GPlearn), sr_tengp (TenGP), sr_deap (DEAP)

**Neural Networks:** nn_neuralut (NeuraLUT), nn_ai4eda (AI4EDA), nn_boolformer (BoolFormer), nn_difflogic (DiffLogic)

**Logic Synthesis:** bdd (BDD), qm (Quine-McCluskey), espresso (Espresso), abc (ABC)

**Large Language Models:** gpt_4o (GPT-4o), gpt_o3 (GPT-o3)

## Parameters

**Required Parameters:**
- -m, --method: List of methods to test (required)
- -d, --data: Data path (relative to data/ directory) (required)
- -p, --problem: Logic operators to test(and, not, or) (required)

**Optional Parameters:**
- -n, --num-files: Limit number of test files (default: all files)
- -s, --split: Train/test split ratio (default: 0.75)
- -o, --output-dir: Output directory (default: output)

## Output Results

Test results are saved in the output/ directory, including:
- Accuracy statistics
- Complexity
- Runtime
- Expressions
- Detailed result JSON files

## Data Format

The data should be organized according to one of the following structures:

**Format 1:**
```
data/
├── [dataset_name]/
│   ├── [input_output_config]/
│   │   ├── [problem_type]/
│   │   │   ├── [noise_level]/
│   │   │   │   ├── 1.truth
│   │   │   │   ├── 2.truth
│   │   │   │   └── ...
```

**Format 2:**
```
data/
├── [dataset_name]/
│   ├── [noise_level] (if any)/
│   │   ├── [input_output_config]/
│   │   │   ├── 1.truth
│   │   │   ├── 2.truth
│   │   │   └── ...
```

**File Format:** Each .truth file contains binary truth table data:
- For a dataset with m inputs and n outputs: total of m + n rows
- First m rows: input variables x1, x2, ..., xm
- Last n rows: output variables y1, y2, ..., yn
- Length of each row = 2^m
- Binary format (0s and 1s)
- Example: For a dataset with 2 inputs and 1 output, the .truth file has 3 rows, each containing 2^2 binary entries.

**Example Structure:**
- ANO/in5_out5/and10/noise_0/1.truth - 5 inputs, 5 outputs, and_num, no noise
- IWLS/in5_out1/1.truth - 5 inputs, 1 output
- BBM/noise_05/in5_out5/7.truth - 5 inputs, 5 outputs, 5% noise